/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.widgets;

import dev.toma.gunsrpg.util.ModUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class EnumButton<E extends Enum<E>>
extends AbstractButton {
    private final EnumSet<E> values;
    private final ClickResponder<E> clickResponder;
    private Function<E, ITextComponent> toComponent = e -> new StringTextComponent(e.name());
    private E value;

    public EnumButton(int x, int y, int width, int height, E value, ClickResponder<E> clickResponder) {
        this(x, y, width, height, value, EnumSet.allOf(((Enum)value).getDeclaringClass()), clickResponder);
    }

    public EnumButton(int x, int y, int width, int height, E value, Collection<E> validValues, ClickResponder<E> clickResponder) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.clickResponder = clickResponder;
        this.value = value;
        this.func_238482_a_(this.toComponent.apply(value));
        this.values = EnumSet.noneOf(((Enum)value).getDeclaringClass());
        this.values.addAll(validValues);
    }

    public void func_230930_b_() {
        this.value = ModUtils.getEnumByIdSafely(((Enum)this.value).ordinal() + 1, ((Enum)this.value).getDeclaringClass());
        this.clickResponder.onClicked(this.value);
    }

    public void setToComponentTransformer(Function<E, ITextComponent> toComponent) {
        this.toComponent = toComponent;
    }

    public static <E extends Enum<E>> ITextComponent upperCaseFormat(E value) {
        String name = value.name();
        String formatted = name.replaceAll("_+", " ").toUpperCase();
        return new StringTextComponent(formatted);
    }

    @FunctionalInterface
    public static interface ClickResponder<E extends Enum<E>> {
        public void onClicked(E var1);
    }
}

